# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 7
# Experiment: PMxPM, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR7_strategy.txt
# LLM Suggested Fallback: Not Provided

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR7(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    total_rounds = 10
    
    # Round 1: Cooperate
    if current_round == 1:
        return "C"
    
    # Check for unconditional strategies in opponent's code
    if "always D" in opponent_program_code or "return 'D'" in opponent_program_code:
        return "D"
    if "always C" in opponent_program_code or "return 'C'" in opponent_program_code:
        return "D"
    
    # Grim trigger if opponent defected in Round 1
    if opp_history[0] == "D":
        return "D"
    
    # Early Rounds (2-3): Tit-for-Tat
    if current_round <= 3:
        return opp_history[-1]
    
    # Mid-Game (Rounds 4-7)
    if current_round <= 7:
        # If opponent cooperated consistently, continue cooperating
        if all(move == "C" for move in opp_history):
            return "C"
        # If opponent defected, defect with increasing probability
        if "D" in opp_history:
            defect_prob = 0.5 + 0.25 * (current_round - 4)
            if random.random() < defect_prob:
                return "D"
            else:
                return "C"
    
    # End-Game (Rounds 8-10)
    if current_round >= 8:
        # If mutual cooperation dominated, continue cooperating
        if len(opp_history) == len([m for m in opp_history if m == "C"]):
            return "C"
        # If opponent defected frequently, defect
        if opp_history.count("D") > opp_history.count("C"):
            return "D"
        # If scores are close, defect in final round
        if current_round == total_rounds:
            return "D"
    
    # Default: Tit-for-Tat
    return opp_history[-1]